<!-- Sidebar -->
<?php
    $routename = request()
        ->route()
        ->getName();
    $role = json_decode(Cookie::get('user'))->role->name;

?>
<div class="sidebar sidebar-style-2" data-background-color="<?php echo e($sidebarColor); ?>">
    <div class="sidebar-wrapper scrollbar scrollbar-inner">
        <div class="sidebar-content">
            <ul class="nav nav-primary">
                <li class="nav-item ml-3 <?php echo e($routename == 'dashboard' ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('dashboard')); ?>" aria-expanded="false">
                        <i class="fas fa-home"></i>
                        <p>Dashboard</p>
                    </a>
                </li>
                <li class="nav-section">
                    <span class="sidebar-mini-icon">
                        <i class="fa fa-ellipsis-h"></i>
                    </span>
                    <h4 class="text-section">Master</h4>
                </li>
                
                <?php if($role == 'USER'): ?>
                    <li class="nav-item ml-3 <?php echo e($routename == 'hall-profile' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('hall-profile')); ?>">
                            <i class="fas fa-door-open"></i>
                            <p>Profile Balai</p>
                        </a>
                    </li>
                    <li class="nav-item ml-3 <?php echo e($routename == 'hall-contact' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('hall-contact')); ?>">
                            <i class="fas fa-envelope"></i>
                            <p>Kontak Balai</p>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if($role == 'ADMIN'): ?>
                    <li class="nav-item ml-3 <?php echo e($routename == 'hall' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('hall')); ?>">
                            <i class="fas fa-door-open"></i>
                            <p>Balai</p>
                        </a>
                    </li>
                    <li class="nav-item ml-3 <?php echo e($routename == 'slide' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('slide')); ?>">
                            <i class="fas fa-images"></i>
                            <p>Slide</p>
                        </a>
                    </li>
                <?php endif; ?>

                
                <li class="nav-item ml-3 <?php echo e($routename == 'news' ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('news')); ?>">
                        <i class="fas fa-newspaper"></i>
                        <p>Berita</p>
                    </a>
                </li>


                
                <?php if($role == 'ADMIN'): ?>
                    <li class="nav-item ml-3 <?php echo e($routename == 'pages' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('pages')); ?>">
                            <i class="fas fa-money-bill-alt"></i>
                            <p>Home Anggaran</p>
                        </a>
                    </li>
                    <li class="nav-item ml-3 <?php echo e($routename == 'infographic' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('infographic')); ?>">
                            <i class="fas fa-chart-bar"></i>
                            <p>Infografis</p>
                        </a>
                    </li>
                    <li class="nav-item ml-3 <?php echo e($routename == 'count-information' ? 'active' : ''); ?>"">
                        <a href="<?php echo e(route('count-information')); ?>">
                            <i class="fas fa-info-circle"></i>
                            <p>Jumlah Informasi</p>
                        </a>
                    </li>
                    <li class="nav-item ml-3 <?php echo e($routename == 'portal-data' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('portal-data')); ?>">
                            <i class="fas fa-database"></i>
                            <p>Portal Data</p>
                        </a>
                    </li>
                    <li class="nav-item ml-3 <?php echo e($routename == 'official-ppid' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('official-ppid')); ?>">
                            <i class="fas fa-users"></i>
                            <p>Pejabat PPID</p>
                        </a>
                    </li>
                    <li
                        class="nav-item ml-3  <?php echo e($routename == 'gallery' || $routename == 'image-gallery' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('gallery')); ?>">
                            <i class="fas fa-camera"></i>
                            <p>Foto</p>
                        </a>
                    </li>
                    <li class="nav-item ml-3 <?php echo e($routename == 'video' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('video')); ?>">
                            <i class="fas fa-video"></i>
                            <p>Video</p>
                        </a>
                    </li>
                <?php endif; ?>

                <li class="nav-item ml-3 <?php echo e($routename == 'agenda' ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('agenda')); ?>">
                        <i class="fas fa-calendar-alt"></i>
                        <p>Agenda</p>
                    </a>
                </li>
                <li class="nav-item ml-3 <?php echo e($routename == 'download' ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('download')); ?>">
                        <i class="fas fa-download"></i>
                        <p>Download</p>
                    </a>
                </li>

                
                <?php if($role == 'ADMIN'): ?>
                    <li
                        class="nav-item ml-3 <?php echo e($routename == 'regulation' || $routename == 'regulation-file' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('regulation')); ?>">
                            <i class="fas fa-file-alt"></i>
                            <p>Regulasi</p>
                        </a>
                    </li>
                    <li class="nav-item ml-3 <?php echo e($routename == 'link' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('link')); ?>">
                            <i class="fas fa-external-link-alt"></i>
                            <p>Link Terkait</p>
                        </a>
                    </li>
                    <li class="nav-item ml-3 <?php echo e($routename == 'contact-us' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('contact-us')); ?>">
                            <i class="fas fa-envelope"></i>
                            <p>Hubungi Kami</p>
                        </a>
                    </li>
                    <li class="nav-item ml-3 <?php echo e($routename == 'user' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('user')); ?>">
                            <i class="fas fa-users-cog"></i>
                            <p>Pengguna</p>
                        </a>
                    </li>
                    <li class="nav-item ml-3 <?php echo e($routename == 'review' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('review')); ?>">
                            <i class="fas fa-book-open"></i>
                            <p>Testimoni</p>
                        </a>
                    </li>
                    <li class="nav-item ml-3 <?php echo e($routename == 'setting' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('setting')); ?>">
                            <i class="fas fa-cog"></i>
                            <p>Setting</p>
                        </a>
                    </li>
                    <li class="nav-section">
                        <span class="sidebar-mini-icon">
                            <i class="fa fa-ellipsis-h"></i>
                        </span>
                        <h4 class="text-section">Information</h4>
                    </li>
                    <li class="nav-item ml-3 <?php echo e($routename == 'public-information' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('public-information')); ?>">
                            <i class="fas fa-info-circle"></i>
                            <p>Informasi Publik</p>
                        </a>
                    </li>
                    <li class="nav-item ml-3 <?php echo e($routename == 'public-information-news' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('public-information-news')); ?>">
                            <i class="fas fa-list-alt"></i>
                            <p>Daftar Informasi</p>
                        </a>
                    </li>
                    <li class="nav-item ml-3 <?php echo e($routename == 'form' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('form')); ?>">
                            <i class="fas fa-clipboard"></i>
                            <p>Formulir</p>
                        </a>
                    </li>
                    <li class="nav-section">
                        <span class="sidebar-mini-icon">
                            <i class="fa fa-ellipsis-h"></i>
                        </span>
                        <h4 class="text-section">Management</h4>
                    </li>
                    <li class="nav-item ml-3 <?php echo e($routename == 'profile' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('profile')); ?>">
                            <i class="fas fa-user"></i>
                            <p>Profile</p>
                        </a>
                    </li>
                    <li class="nav-item ml-3 <?php echo e($routename == 'history' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('history')); ?>">
                            <i class="fas fa-book"></i>
                            <p>Sejarah</p>
                        </a>
                    </li>
                    <li class="nav-item ml-3 <?php echo e($routename == 'vision' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('vision')); ?>">
                            <i class="fas fa-eye"></i>
                            <p>Visi Misi</p>
                        </a>
                    </li>
                    <li class="nav-item ml-3 <?php echo e($routename == 'tupoksi' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('tupoksi')); ?>">
                            <i class="fas fa-tasks"></i>
                            <p>Tupoksi</p>
                        </a>
                    </li>
                    <li class="nav-item ml-3 <?php echo e($routename == 'organization' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('organization')); ?>">
                            <i class="fas fa-sitemap"></i>
                            <p>Struktur Organisasi</p>
                        </a>
                    </li>
                    <li class="nav-item ml-3 <?php echo e($routename == 'official' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('official')); ?>">
                            <i class="fas fa-id-card"></i>
                            <p>Profil Pejabat</p>
                        </a>
                    </li>
                <?php endif; ?>

                <li class="nav-item ml-3 <?php echo e($routename == 'account' ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('account')); ?>">
                        <i class="fas fa-user-cog"></i>
                        <p>Setting Akun</p>
                    </a>
                </li>
                <li class="nav-section">
                    <span class="sidebar-mini-icon">
                        <i class="fa fa-ellipsis-h"></i>
                    </span>
                    <h4 class="text-section">Logout</h4>
                </li>
                <li class="nav-item ml-3">
                    <a href="<?php echo e(route('logout')); ?>">
                        <i class="fas fa-sign-out-alt"></i>
                        <p>Logout</p>
                    </a>
                </li>
            </ul>
        </div>
    </div>
</div>
<!-- End Sidebar -->
<?php /**PATH /Users/macbook/Downloads/ppid-kominfo-master 2/resources/views/partials/dashboard/sidebar.blade.php ENDPATH**/ ?>